package ru.yandex.mail.so.logger.config;

import ru.yandex.logger.AbstractLoggerConfigBuilder;
import ru.yandex.logger.LoggerConfigDefaults;
import ru.yandex.logger.LoggerFileConfig;
import ru.yandex.mail.so.logger.Route;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public abstract class AbstractStoreLoggerConfigBuilder<T extends AbstractStoreLoggerConfigBuilder<T>>
    extends AbstractLoggerConfigBuilder<T> implements StoreLoggerConfig
{
    private Route route;

    protected AbstractStoreLoggerConfigBuilder(final StoreLoggerConfig config) {
        super(config);
        route = config.route();
    }

    protected AbstractStoreLoggerConfigBuilder(
        final IniConfig config,
        final StoreLoggerConfig defaults)
        throws ConfigException
    {
        super(config, defaults == null ? LoggerConfigDefaults.INSTANCE : defaults);
        route = config.get("route", defaults == null ? null : defaults.route(), new EnumParser<>(Route.class));
    }

    protected AbstractStoreLoggerConfigBuilder(
        final IniConfig config,
        final StoreLoggerConfig defaults,
        final LoggerFileConfig defaultFileConfig)
        throws ConfigException
    {
        super(config, defaults == null ? LoggerConfigDefaults.INSTANCE : defaults, defaultFileConfig);
        route = config.get("route", defaults == null ? null : defaults.route(), new EnumParser<>(Route.class));
    }

    @Override
    public Route route() {
        return route;
    }

    public T route(final Route route) {
        this.route = route;
        return self();
    }
}
