package ru.yandex.mail.so.logger.config;

import java.io.IOException;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSpLoggerConsumerConfig extends ImmutableHttpProxyConfig implements SpLoggerConsumerConfig {
    private final EnvironmentType envType;
    private final ImmutableStoreLogHandlersConfig storeLogHandlersConfig;
    private final ImmutableRulesStatDatabasesConfig rulesStatDatabasesConfig;

    public ImmutableSpLoggerConsumerConfig(final SpLoggerConsumerConfig config) throws ConfigException, IOException {
        super(config);
        envType = config.envType();
        storeLogHandlersConfig = new ImmutableStoreLogHandlersConfig(config.storeLogHandlersConfig());
        rulesStatDatabasesConfig = new ImmutableRulesStatDatabasesConfig(config.rulesStatDatabasesConfig());
    }

    @Override
    public EnvironmentType envType() {
        return envType;
    }

    @Override
    public ImmutableStoreLogHandlersConfig storeLogHandlersConfig() {
        return storeLogHandlersConfig;
    }

    @Override
    public ImmutableRulesStatDatabasesConfig rulesStatDatabasesConfig() {
        return rulesStatDatabasesConfig;
    }
}
