package ru.yandex.mail.so.logger.config;

import java.util.logging.Logger;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.logger.HandlersManager;
import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableStoreLogHandlerConfig extends ImmutableStaterConfig implements StoreLogHandlerConfig {
    private static final GenericFunction<StoreLoggerConfig, ImmutableStoreLoggerConfig, ConfigException>
        TRANSFORMER = config -> {
            if (config == null) {
                return null;
            } else {
                return new ImmutableStoreLoggerConfig(config);
            }
        };

    private final String baseDir;
    private final String decompression;
    private final Pattern<RequestInfo> basePattern;
    private final LogRecordsHandlerType logRecordsHandlerType;
    private final PatternMap<RequestInfo, ImmutableStoreLoggerConfig> loggers;
    private final String rulesStatDatabase;

    public ImmutableStoreLogHandlerConfig(final StoreLogHandlerConfig config) throws ConfigException {
        super(config);
        baseDir = config.baseDir();
        decompression = config.decompression();
        basePattern = config.basePattern();
        rulesStatDatabase = config.rulesStatDatabase();
        logRecordsHandlerType = config.type();
        loggers = config.loggers().transform(TRANSFORMER);
    }

    @Override
    public String baseDir() {
        return baseDir;
    }

    @Override
    public String decompression() {
        return decompression;
    }

    @Override
    public Pattern<RequestInfo> basePattern() {
        return basePattern;
    }

    @Override
    public LogRecordsHandlerType type() {
        return logRecordsHandlerType;
    }

    @Override
    public String rulesStatDatabase() {
        return rulesStatDatabase;
    }

    @Override
    public PatternMap<RequestInfo, ImmutableStoreLoggerConfig> loggers() {
        return loggers;
    }

    public PatternMap<RequestInfo, Logger> build(final HandlersManager handlersManager) throws ConfigException {
        if (handlersManager == null) {
            return null;
        } else {
            return loggers.transform(config -> {
                if (config == null) {
                    return null;
                } else {
                    return config.build(handlersManager);
                }
            });
        }
    }
}
