package ru.yandex.mail.so.logger.config;

import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableStoreLogHandlersConfig implements StoreLogHandlersConfig {
    private static final GenericFunction<StoreLogHandlerConfig, ImmutableStoreLogHandlerConfig, ConfigException>
        TRANSFORMER = config -> {
            if (config == null) {
                return null;
            } else {
                return new ImmutableStoreLogHandlerConfig(config);
            }
        };

    private final PatternMap<RequestInfo, ImmutableStoreLogHandlerConfig> storeLogHandlerConfigs;

    public ImmutableStoreLogHandlersConfig(final StoreLogHandlersConfig config) throws ConfigException {
        storeLogHandlerConfigs = config.storeLogHandlers().transform(TRANSFORMER);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableStoreLogHandlerConfig> storeLogHandlers() {
        return storeLogHandlerConfigs;
    }
}
