package ru.yandex.mail.so.logger.config;

import java.io.IOException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SpLoggerConsumerConfigBuilder extends AbstractSpLoggerConsumerConfigBuilder<SpLoggerConsumerConfigBuilder>
    implements SpLoggerConsumerConfig
{
    public SpLoggerConsumerConfigBuilder() {
        super(SpLoggerConsumerConfigDefaults.INSTANCE);
    }

    public SpLoggerConsumerConfigBuilder(final SpLoggerConsumerConfig config) {
        super(config);
    }

    public SpLoggerConsumerConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, SpLoggerConsumerConfigDefaults.INSTANCE);
    }

    public SpLoggerConsumerConfigBuilder(final IniConfig config, final SpLoggerConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SpLoggerConsumerConfigBuilder self() {
        return this;
    }

    public ImmutableSpLoggerConsumerConfig build() throws ConfigException, IOException {
        return new ImmutableSpLoggerConsumerConfig(this);
    }
}
