package ru.yandex.mail.so.logger.config;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.stater.StaterConfig;

public interface StoreLogHandlerConfig extends StaterConfig {
    /**
     * Get base directory for all log files related to this store handler
     *
     * @return base directory for all log files related to this store handler
     */
    String baseDir();

    /**
     * Get decompression method for all log to be received by this store handler
     *
     * @return decompression method for all log to be received by this store handler
     */
    String decompression();

    /**
     * Get base pattern for all requests related to this store handler
     *
     * @return base pattern for all requests related to this store handler
     */
    Pattern<RequestInfo> basePattern();

    /**
     * Get type of all logs received by this store handler
     *
     * @return type of all logs received by this store handler
     */
    LogRecordsHandlerType type();

    /**
     * Get all loggers configs related to this store handler
     *
     * @return loggers configs related to this store handler
     */
    PatternMap<RequestInfo, ? extends StoreLoggerConfig> loggers();

    /**
     * Get config name of the database for store rules statistics by this store handler
     *
     * @return config name of the database for store rules statistics by this store handler
     */
    String rulesStatDatabase();
}
