package ru.yandex.mail.so.logger.config;

import ru.yandex.collection.Pattern;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class StoreLogHandlerConfigBuilder extends AbstractStoreLogHandlerConfigBuilder<StoreLogHandlerConfigBuilder>
{
    public StoreLogHandlerConfigBuilder() {
        super(StoreLogHandlerConfigDefaults.INSTANCE);
    }

    public StoreLogHandlerConfigBuilder(final StoreLogHandlerConfig config) {
        super(config);
    }

    @SuppressWarnings("unused")
    public StoreLogHandlerConfigBuilder(final IniConfig config, final Pattern<RequestInfo> pattern)
        throws ConfigException
    {
        super(config, pattern, StoreLogHandlerConfigDefaults.INSTANCE);
    }

    public StoreLogHandlerConfigBuilder(
        final IniConfig config,
        final Pattern<RequestInfo> pattern,
        final StoreLogHandlerConfig defaults)
        throws ConfigException
    {
        super(config, pattern, defaults);
    }

    @Override
    public StoreLogHandlerConfigBuilder self() {
        return this;
    }

    public ImmutableStoreLogHandlerConfig build() throws ConfigException {
        return new ImmutableStoreLogHandlerConfig(this);
    }
}
