package ru.yandex.mail.so.logger.config;

import javax.annotation.Nonnull;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.mail.so.logger.LogRecordsHandlerType;
import ru.yandex.stater.StaterConfigDefaults;

public class StoreLogHandlerConfigDefaults extends StaterConfigDefaults implements StoreLogHandlerConfig
{
    public static final StoreLogHandlerConfigDefaults INSTANCE = new StoreLogHandlerConfigDefaults();

    protected StoreLogHandlerConfigDefaults() {
    }

    @Override
    public String baseDir() {
        return null;
    }

    @Override
    public String decompression() {
        return "raw";
    }

    @Override
    public Pattern<RequestInfo> basePattern() {
        return new Pattern<>("", true);
    }

    @Nonnull
    @Override
    public LogRecordsHandlerType type() {
        return LogRecordsHandlerType.NULL;
    }

    @Override
    public PatternMap<RequestInfo, ? extends StoreLoggerConfig> loggers() {
        return new PatternMap<>(StoreLoggerConfigDefaults.INSTANCE);
    }

    @Override
    public String rulesStatDatabase() {
        return null;
    }
}
