package ru.yandex.mail.so.logger.config;

import ru.yandex.logger.LoggerFileConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class StoreLoggerConfigBuilder extends AbstractStoreLoggerConfigBuilder<StoreLoggerConfigBuilder> {
    public StoreLoggerConfigBuilder() {
        this(StoreLoggerConfigDefaults.INSTANCE);
    }

    public StoreLoggerConfigBuilder(final StoreLoggerConfig config) {
        super(config);
    }

    public StoreLoggerConfigBuilder(final IniConfig config) throws ConfigException
    {
        this(config, StoreLoggerConfigDefaults.INSTANCE);
    }

    public StoreLoggerConfigBuilder(final IniConfig config, final StoreLoggerConfig defaults) throws ConfigException
    {
        super(config, defaults);
    }

    public StoreLoggerConfigBuilder(
        final IniConfig config,
        final StoreLoggerConfig defaults,
        final LoggerFileConfig defaultFileConfig)
        throws ConfigException
    {
        super(config, defaults, defaultFileConfig);
    }

    public ImmutableStoreLoggerConfig build() throws ConfigException {
        return new ImmutableStoreLoggerConfig(this);
    }

    @Override
    public StoreLoggerConfigBuilder self() {
        return this;
    }
}
