#!/bin/bash
set -exo pipefail

source recommended_java_args.sh
export GC_LOG_ARGS="-Xverbosegclog:/dev/shm/gc#.log,10,10000"
export JAVA_ARGS="$JAVA_ARGS $GC_LOG_ARGS"
export JAVA_LD_PRELOAD=${JAVA_LD_PRELOAD:+$JAVA_LD_PRELOAD:}/usr/lib/libtcmalloc_minimal.so.4

export LOG_DIR=/logs
export CORE_DIR=/cores
export STATE_DIR=/state
export POD_ID=$YP_POD_ID
export SP_LOGGER_CONSUMER_PORT=${BSCONFIG_IPORT:-80}
export LOGROTATE_DAYS=2

[ -z "$YP_TOKEN" -a -e "./yp/token" ] && export YP_TOKEN=$(cat ./yp/token)
[ -n "$MEM_LIMIT" ] && export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.9)}')
[ -n "$CPU_LIMIT" ] && export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')

GB=$(( 1024*1024*1024 ))
GB0_5=$(( GB / 2 ))
GB1_5=$(( GB + (GB / 2) ))
export MEMORY_GAP=${MEMORY_GAP:-$GB0_5}

case "$NANNY_SERVICE_ID" in
    so_logger_consumer)
        export CTYPE=prod
        ;;
    so_logger_consumer_testing)
        export CTYPE=testing
        ;;
esac

export SP_LOGGER_CONSUMER_CONFIG_FILE=sp-logger-consumer-${CTYPE}.conf
