#!/bin/bash
set -x

source config.sh

DT=`date -d yesterday +%Y-%m-%d`
LOGS_DIR="${LOG_DIR}/statlog"
LOGS=(
"delivery_in 3 log"
"delivery_out 3 log"
"delivery_corp 3 log"
)

for log in "${LOGS[@]}"; do
	set -- $log
	file_ext=
    [ -n "$3" ] && file_ext=".$3"
	[ -f "${LOGS_DIR}/$1$file_ext" ] && mv -f "${LOGS_DIR}/$1$file_ext" "${LOGS_DIR}/${1}_$DT$file_ext"
    touch "${LOGS_DIR}/$1$file_ext"
done

/usr/bin/curl -s -v "http://localhost:${SP_LOGGER_CONSUMER_PORT}/logrotate"

# /bin/kill -TERM $(cat pids/push-client-sologger)

for log in "${LOGS[@]}"; do
	set -- $log
    find ${LOGS_DIR}/ -type f -mtime +$2 -name "${1}_*" -delete
done
