#!/bin/bash
set -exo pipefail

source config.sh

STATUS_PORTS=(
$SP_LOGGER_CONSUMER_PORT
)

PING_PORTS=(
)

end_date=$(expr $(date +%s) + 3600)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        >&2 echo Status script timed out
        exit 1
    fi

    # Fast check clients, if any client is in any state except ACTIVE, exit 1
    # If /status is not available, probably service is not started yet,
    # just skip this check
    for status_port in ${STATUS_PORTS[@]}
    do
        if ! FAIL_FAST_EXIT_CODE=0 PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
        then
            >&2 echo "Port $status_port /status check failed"
            exit 1
        fi
    done

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            >&2 echo "Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    break
done

sleep 5
for status_port in ${STATUS_PORTS[@]}
do
    if ! PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
    then
        >&2 echo "Port $status_port /status second check failed"
        exit 1
    fi
done

failed=0
for ping_port in ${PING_PORTS[@]}
do
    if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
    then
        >&2 echo "Port $ping_port /ping second check failed"
        exit 1
    fi
done

exit 0

