package ru.yandex.mail.so.logger.launcher;

import ru.yandex.collection.Pattern;
import ru.yandex.dispatcher.consumer.ConsumerServer;
import ru.yandex.dispatcher.consumer.ConsumerServerFactory;
import ru.yandex.dispatcher.producer.PostDataHandler;
import ru.yandex.dispatcher.producer.Producer;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.server.DefaultHttpServerFactory;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.mail.so.logger.SpLogger;
import ru.yandex.msearch.Daemon;
import ru.yandex.stater.PrefixingStater;

public final class SpLoggerLauncher {
    private SpLoggerLauncher() {
    }

    public static void main(final String... args) {
        int idx = 0;
        try {
            Producer producer =
                Producer.class.cast(
                    Producer.main(
                        new DefaultHttpServerFactory<>(Producer.class),
                        args[idx++]));
            String ctype = System.getenv("CTYPE");
            if (ctype == null || ctype.isEmpty()) {
                ctype = "prod";
            }
            String queueName = ctype.equals("prod") ? System.getenv("QUEUE_NAME") : System.getenv("QUEUE_TEST_NAME");
            if (queueName == null || queueName.isEmpty()) {
                queueName = ctype.equals("prod") ? "sologger" : "sologger-test";
            }
            SpLoggerIndexUpdateHandler spLoggerIndexUpdateHandler =
                new SpLoggerIndexUpdateHandler(queueName, new PostDataHandler(producer));
            producer.register(new Pattern<>("/add", true), spLoggerIndexUpdateHandler, RequestHandlerMapper.GET);
            producer.register(new Pattern<>("/modify", true), spLoggerIndexUpdateHandler, RequestHandlerMapper.GET);
            //producer.register(new Pattern<>("/delete", true), spLoggerIndexUpdateHandler, RequestHandlerMapper.GET);
            Daemon daemon = Daemon.createDaemon(args[idx++]);
            HttpServer<?, ?> spLogger =
                SpLogger.main(
                    new DefaultHttpServerFactory<>(SpLogger.class),
                    args[idx++]);
            HttpServer<?, ?> consumer =
                ConsumerServer.main(new ConsumerServerFactory(), args[idx++]);
            HttpServer<?, ?> deleteConsumer = null;
            if (idx < args.length) {
                deleteConsumer = ConsumerServer.main(new ConsumerServerFactory(), args[idx]);
            }
            spLogger.registerStater(new PrefixingStater("producer-", producer));
            spLogger.registerStater(new PrefixingStater("consumer-", consumer));
            spLogger.registerStater(new PrefixingStater("searcher-", daemon.httpSearchServer()));
            spLogger.registerStater(new PrefixingStater("indexer-", daemon.jsonIndexerServer()));
            if (idx < args.length) {
                spLogger.registerStater(new PrefixingStater("delete-consumer-", deleteConsumer));
            }
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

