#!/bin/bash
set -exo pipefail

source sp_logger_config_base.sh
source recommended_search_backend_args.sh

export SP_LOGGER_PORT=${BSCONFIG_IPORT:-80}
export INDEXER_PORT=${BSCONFIG_IPORT_PLUS_4:-84}
export OLD_SEARCH_PORT=${BSCONFIG_IPORT_PLUS_3:-83}
export DUMP_PORT=${BSCONFIG_IPORT_PLUS_13:-93}
export SEARCH_PORT=${BSCONFIG_IPORT_PLUS_8:-88}
export CONSUMER_PORT=${BSCONFIG_IPORT_PLUS_9:-89}
export PRODUCER_PORT=${BSCONFIG_IPORT_PLUS_1:-81}
export CONSUMER_DELETES_PORT=${BSCONFIG_IPORT_PLUS_7:-87}
export SHARDS=434
export SP_LOGGER_TVM2_ID=2025242

export QUEUE_NAME=sologger
export QUEUE_TEST_NAME=sologger-test

export WATCHDOG_QUEUE_NAME=sp_logger_watchdog
export WATCHDOG_ZOO_SHARD_ID=0
export WATCHDOG_PREFIX=$((SHARDS * 5))

export INDEX_DIR=${DATA_DIR:-/data}/index
export SEARCHMAP_PATH=searchmap.txt
export SEARCHMAP_DELETES_PATH=searchmap_deletes.txt
export SEARCHMAP_PRODUCER_PATH=searchmap_producer.txt

export LOGROTATE_DAYS=2

GB=$(( 1024*1024*1024 ))
GB0_5=$(( GB / 2 ))
GB1_5=$(( GB + (GB / 2) ))
export MEMORY_GAP=${MEMORY_GAP:-$GB0_5}
#[[ "$MEMORY_LIMIT" -lt "1" || -z "$MEMORY_LIMIT" ]] && export MEMORY_LIMIT=$((10*1024*1024*1024))
#[[ "$CPU_CORES" -lt "1" || -z "$CPU_CORES" ]] && export CPU_CORES=5

case "$NANNY_SERVICE_ID" in
    so_logger_backend)
        export CTYPE=prod
        export MDS_TVM2_ID=2000273
        export SHARDS_PER_HOST=62
        export ENDPOINT_SETS_IDS=(sp-logger-service)
        #export DEFAULT_DC_PODS_COUNT=2
        export GEOS=("iva 7" "sas 7" "vla 7")
        export SP_LOGGER_BATCH_SAVE_MAX_RPS=1
        export SP_LOGGER_BATCH_SAVE_TIMEOUT=2s
        export SP_LOGGER_STORAGE_RETRY_TIMEOUT=1m
        export SP_LOGGER_BATCHES_MEM_LIMIT=2G
        export SP_LOGGER_BATCH_MIN_SIZE=10M
        export SP_LOGGER_BATCH_MAX_SIZE=200M
        export MDS_WRITE_HOST="storage-int.mds.yandex.net"
        export MDS_NAMESPACE=$QUEUE_NAME
        export MDS_OTHER_NAMESPACE=$QUEUE_TEST_NAME
        export MDS_OTHER_WRITE_HOST="storage-int.mdst.yandex.net"
        ;;
    so_logger_backend_testing)
        export CTYPE=testing
        export SHARDS=14
        export MDS_TVM2_ID=2000272
        export SHARDS_PER_HOST=14
        export ENDPOINT_SETS_IDS=(sp-logger-service-testing)
        #export DEFAULT_DC_PODS_COUNT=1
        export GEOS=("myt 1")
        export SP_LOGGER_BATCH_SAVE_MAX_RPS=1
        export SP_LOGGER_BATCH_SAVE_TIMEOUT=500ms
        export SP_LOGGER_STORAGE_RETRY_TIMEOUT=10m
        export SP_LOGGER_BATCHES_MEM_LIMIT=1G
        export SP_LOGGER_BATCH_MIN_SIZE=5M
        export SP_LOGGER_BATCH_MAX_SIZE=200M
        export MDS_WRITE_HOST="storage-int.mdst.yandex.net"
        export MDS_NAMESPACE=$QUEUE_TEST_NAME
        export MDS_OTHER_NAMESPACE=$QUEUE_NAME
        export MDS_OTHER_WRITE_HOST="storage-int.mds.yandex.net"
        ;;
esac

export MDS_WRITE_PORT=1111
export MDS_DELETE_QUEUE_NAME=sologger_delete
export SP_LOGGER_CONFIG_FILE=sp-logger-${CTYPE}.conf
