#!/bin/bash
set -exo pipefail

source config.sh

#zooloosers=$(list_zooloosers ${QUEUE_DEFAULT_DC_PODS_COUNT:-3} ${QUEUE_ENDPOINT_SETS_IDS[@]})
# pods=$(for geo_info in "${GEOS[@]}"; do set -- $geo_info; list_backends $2 $NANNY_SERVICE_ID $1 ${ENDPOINT_SETS_IDS[@]}; done)

truncate -s0 $SEARCHMAP_PATH
truncate -s0 $SEARCHMAP_DELETES_PATH

for geo_info in "${GEOS[@]}"; do
    set -- $geo_info
    pods=$(list_backends $2 $NANNY_SERVICE_ID $1 ${ENDPOINT_SETS_IDS[@]})
    if [ "$CTYPE" == "testing" ]; then
        echo "# $QUEUE_TEST_NAME ($1)" >> $SEARCHMAP_PATH
        generate_searchmap_for_geo $QUEUE_TEST_NAME $1 $SHARDS $2 $SEARCH_PORT $INDEXER_PORT $pods >> $SEARCHMAP_PATH
    else
        echo "# $QUEUE_NAME ($1)" >> $SEARCHMAP_PATH
        generate_searchmap_for_geo $QUEUE_NAME $1 $SHARDS $2 $SEARCH_PORT $INDEXER_PORT $pods >> $SEARCHMAP_PATH
    fi
    case "$NANNY_SERVICE_ID" in
        so_logger_backend*)
            echo "# $MDS_DELETE_QUEUE_NAME ($1)" >> $SEARCHMAP_DELETES_PATH
            generate_searchmap_for_mds_delete_geo $MDS_DELETE_QUEUE_NAME $1 $SHARDS $2 $MDS_WRITE_HOST $MDS_WRITE_PORT $pods >> $SEARCHMAP_DELETES_PATH
        ;;
    esac
done

case "$NANNY_SERVICE_ID" in
    so_logger_backend*)
        cat $SEARCHMAP_PATH >> $SEARCHMAP_PRODUCER_PATH
        cat $SEARCHMAP_DELETES_PATH >> $SEARCHMAP_PRODUCER_PATH
    ;;
esac
