#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

XMX=$(( (MEMORY_LIMIT - MEMORY_GAP) / 1048576))
GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx${XMX}M
-Xms${XMX}M
-Xmn512M
-XX:ParallelGCThreads=$CPU_CORES
-XX:ConcGCThreads=1
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
"
ADDITIONAL_ARGS="-XX:ActiveProcessorCount=6 -Dru.yandex.dispatcher-zk.reconnect-threads=4"

LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    $NET_ARGS $GC_ARGS $ADDITIONAL_ARGS \
    -Djava.library.path=sp_logger_service \
    -cp $CLASSPATH ru.yandex.mail.so.logger.launcher.SpLoggerLauncher \
    producer.conf \
    search_backend.conf \
    $SP_LOGGER_CONFIG_FILE \
    consumer.conf \
    consumer-delete.conf

