#!/bin/bash

source config.sh

DEADLINE=$(date +%s)
CLEANUP_LOG=${LOG_DIR}/cleanup.log
BATCH_SIZE=10000
DELETE_BATCH_SIZE=1000
shard=$1
RETRY_DELAY=$(( shard + 1 ))

echo $(date)": Start clean up of shard $shard" >> $CLEANUP_LOG
while true; do
    #TVM_TICKET=$(tvmknife get_service_ticket client_credentials --dst $MDS_TVM2_ID --src $SP_LOGGER_TVM2_ID --secret $MDS_TVM2_SECRET)
    batch=$(curl -s --retry 3 --retry-delay $RETRY_DELAY -m 60 "http://localhost:${SEARCH_PORT}/search?prefix=$shard&text=log_expire_timestamp:%5b0+TO+"$DEADLINE"%5d&get=log_stid&length=${BATCH_SIZE}&collector=passthru($BATCH_SIZE)&early-interrupt" 2>/dev/null)
    hits=$(echo $batch | jq '.hitsArray[].log_stid' | wc -l 2>/dev/null)
    if [ "$?" -gt "0" -o "$hits" == "" -o "$hits" == "0" ]; then
        break
    fi
    stids=( $(echo $batch | jq -r '[.hitsArray[].log_stid] | unique | join(" ")') )
    n=${#stids[@]}
    [ -z "$n" -o "$n" -eq "0" ] && break
    hitsCount=$(echo $batch | jq '.hitsCount')
    echo ${stids[@]} | xargs -n $DELETE_BATCH_SIZE -P2 ./sp-logger-delete-group.sh $shard
    echo ${stids[@]} | xargs -n $DELETE_BATCH_SIZE -P5 ./sp-logger-delete-mds-batch.sh $shard
    echo $(date)": Deleted documents batch with next $n stids for shard $shard ($hitsCount documents left)" >> $CLEANUP_LOG
done
echo $(date)": Cleaning of shard $shard DONE" >> $CLEANUP_LOG
