package ru.yandex.mail.so.spampkin;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.util.ip.CidrListConfig;
import ru.yandex.util.ip.CidrListConfigBuilder;

public abstract class AbstractSpampkinConfigBuilder
    <T extends AbstractSpampkinConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements SpampkinConfig
{
    private HttpHostConfigBuilder jrbldConfig;
    private String hamCheckName;
    private String spamCheckName;
    private String rejectCheckName;
    private HttpHostConfigBuilder shinglerConfig;
    private CidrListConfigBuilder intranetIps;
    private boolean outMail;

    protected AbstractSpampkinConfigBuilder(final SpampkinConfig config) {
        super(config);
        jrbldConfig(config.jrbldConfig());
        hamCheckName(config.hamCheckName());
        spamCheckName(config.spamCheckName());
        rejectCheckName(config.rejectCheckName());
        shinglerConfig(config.shinglerConfig());
        intranetIps(config.intranetIps());
        outMail(config.outMail());
    }

    protected AbstractSpampkinConfigBuilder(
        final IniConfig config,
        final SpampkinConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig jrbldSection = config.section("jrbld");
        jrbldConfig =
            new HttpHostConfigBuilder(jrbldSection, defaults.jrbldConfig());
        hamCheckName =
            HAM_CHECK_NAME.extract(jrbldSection, defaults.hamCheckName());
        spamCheckName =
            SPAM_CHECK_NAME.extract(jrbldSection, defaults.spamCheckName());
        rejectCheckName = REJECT_CHECK_NAME.extract(
            jrbldSection,
            defaults.rejectCheckName());
        shinglerConfig = new HttpHostConfigBuilder(
            config.section("shingler"),
            defaults.shinglerConfig());
        intranetIps = new CidrListConfigBuilder(
            config.section("intranet-ips"),
            defaults.intranetIps());
        IniConfig spampkinSection = config.section("spampkin");
        outMail = OUT_MAIL.extract(spampkinSection, defaults.outMail());
    }

    @Override
    public HttpHostConfigBuilder jrbldConfig() {
        return jrbldConfig;
    }

    public T jrbldConfig(final HttpHostConfig jrbldConfig) {
        this.jrbldConfig = new HttpHostConfigBuilder(jrbldConfig);
        return self();
    }

    @Override
    public String hamCheckName() {
        return hamCheckName;
    }

    public T hamCheckName(final String hamCheckName) {
        this.hamCheckName = hamCheckName;
        return self();
    }

    @Override
    public String spamCheckName() {
        return spamCheckName;
    }

    public T spamCheckName(final String spamCheckName) {
        this.spamCheckName = spamCheckName;
        return self();
    }

    @Override
    public String rejectCheckName() {
        return rejectCheckName;
    }

    public T rejectCheckName(final String rejectCheckName) {
        this.rejectCheckName = rejectCheckName;
        return self();
    }

    @Override
    public HttpHostConfigBuilder shinglerConfig() {
        return shinglerConfig;
    }

    public T shinglerConfig(final HttpHostConfig shinglerConfig) {
        this.shinglerConfig = new HttpHostConfigBuilder(shinglerConfig);
        return self();
    }

    @Override
    public CidrListConfigBuilder intranetIps() {
        return intranetIps;
    }

    public T intranetIps(final CidrListConfig intranetIps) {
        this.intranetIps = new CidrListConfigBuilder(intranetIps);
        return self();
    }

    @Override
    public boolean outMail() {
        return outMail;
    }

    public T outMail(final boolean outMail) {
        this.outMail = outMail;
        return self();
    }
}

