package ru.yandex.mail.so.spampkin;

import java.net.InetAddress;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.BinaryTrieSet;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.mail.envelope.SmtpEnvelopeHolder;
import ru.yandex.util.ip.CidrSet;

public class ConnectFastChecker implements SpampkinFastChecker {
    private final Map<Integer, BinaryTrieSet> intranetIps;

    public ConnectFastChecker(final Map<Integer, BinaryTrieSet> intranetIps) {
        this.intranetIps = intranetIps;
    }

    @Override
    public void check(
        final SmtpEnvelopeHolder envelope,
        final ProxySession session,
        final FutureCallback<SoResolution> callback)
    {
        InetAddress ip = envelope.ip();
        SoResolution resolution;
        if (ip != null && CidrSet.INSTANCE.contains(intranetIps, ip)) {
            resolution = SoResolution.ACCEPT;
        } else {
            resolution = SoResolution.UNKNOWN;
        }
        callback.completed(resolution);
    }
}

