package ru.yandex.mail.so.spampkin;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.ip.ImmutableCidrListConfig;

public class ImmutableSpampkinConfig
    extends ImmutableHttpProxyConfig
    implements SpampkinConfig
{
    private final ImmutableHttpHostConfig jrbldConfig;
    private final String hamCheckName;
    private final String spamCheckName;
    private final String rejectCheckName;
    private final ImmutableHttpHostConfig shinglerConfig;
    private final ImmutableCidrListConfig intranetIps;
    private final boolean outMail;

    public ImmutableSpampkinConfig(final SpampkinConfig config)
        throws ConfigException
    {
        super(config);
        jrbldConfig = new ImmutableHttpHostConfig(config.jrbldConfig());
        hamCheckName = HAM_CHECK_NAME.validate(config.hamCheckName());
        spamCheckName = SPAM_CHECK_NAME.validate(config.spamCheckName());
        rejectCheckName = REJECT_CHECK_NAME.validate(config.rejectCheckName());
        shinglerConfig = new ImmutableHttpHostConfig(config.shinglerConfig());
        intranetIps = new ImmutableCidrListConfig(config.intranetIps());
        outMail = OUT_MAIL.validate(config.outMail());
    }

    @Override
    public ImmutableHttpHostConfig jrbldConfig() {
        return jrbldConfig;
    }

    @Override
    public String hamCheckName() {
        return hamCheckName;
    }

    @Override
    public String spamCheckName() {
        return spamCheckName;
    }

    @Override
    public String rejectCheckName() {
        return rejectCheckName;
    }

    @Override
    public ImmutableHttpHostConfig shinglerConfig() {
        return shinglerConfig;
    }

    @Override
    public ImmutableCidrListConfig intranetIps() {
        return intranetIps;
    }

    @Override
    public boolean outMail() {
        return outMail;
    }
}

