package ru.yandex.mail.so.spampkin;

import java.net.InetAddress;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.parser.mail.envelope.SmtpEnvelopeHolder;
import ru.yandex.parser.uri.QueryConstructor;

public class JrbldFastChecker implements SpampkinFastChecker {
    private static final String CHECK = "check";

    private final AsyncClient client;
    private final HttpHost host;
    private final String hamCheckName;
    private final String spamCheckName;
    private final String rejectCheckName;

    public JrbldFastChecker(
        final AsyncClient client,
        final HttpHost host,
        final ImmutableSpampkinConfig config)
    {
        this.client = client;
        this.host = host;
        hamCheckName = config.hamCheckName();
        spamCheckName = config.spamCheckName();
        rejectCheckName = config.rejectCheckName();
    }

    @Override
    public void check(
        final SmtpEnvelopeHolder envelope,
        final ProxySession session,
        final FutureCallback<SoResolution> callback)
    {
        InetAddress ip = envelope.ip();
        if (ip == null) {
            callback.completed(SoResolution.UNKNOWN);
            return;
        }

        QueryConstructor query = new QueryConstructor("/check?", false);
        try {
            query.append("ip", ip.getHostAddress());
            query.append(CHECK, hamCheckName);
            query.append(CHECK, spamCheckName);
            query.append(CHECK, rejectCheckName);
        } catch (BadRequestException e) {
            callback.failed(e);
            return;
        }

        AsyncClient client = this.client.adjust(session.context());
        client.execute(
            host,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.listener().createContextGeneratorFor(client),
            new Callback(callback));
    }

    private class Callback
        extends AbstractFilterFutureCallback<JsonObject, SoResolution>
    {
        Callback(final FutureCallback<SoResolution> callback) {
            super(callback);
        }

        private SoResolution convertResult(final JsonObject result)
            throws JsonException
        {
            JsonObject checks = result.get("checks");
            SoResolution resolution;
            if (checks.get(hamCheckName).asBoolean()) {
                resolution = SoResolution.ACCEPT;
            } else if (checks.get(spamCheckName).asBoolean()) {
                resolution = SoResolution.SPAM;
            } else if (checks.get(rejectCheckName).asBoolean()) {
                resolution = SoResolution.REJECT;
            } else {
                resolution = SoResolution.UNKNOWN;
            }
            return resolution;
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                callback.completed(convertResult(result));
            } catch (JsonException e) {
                e.addSuppressed(
                    new Exception(
                        "Failed to parse JRBLD result: "
                        + JsonType.HUMAN_READABLE.toString(result)));
                failed(e);
            }
        }
    }
}

