package ru.yandex.mail.so.spampkin;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.mail.envelope.SmtpEnvelopeHolder;

public class MultiFastChecker implements SpampkinFastChecker {
    private final SpampkinFastChecker[] checkers;

    public MultiFastChecker(final List<SpampkinFastChecker> checkers) {
        this.checkers =
            checkers.toArray(new SpampkinFastChecker[checkers.size()]);
    }

    @Override
    public void check(
        final SmtpEnvelopeHolder envelope,
        final ProxySession session,
        final FutureCallback<SoResolution> callback)
    {
        Callback multiCallback = new Callback(callback, checkers.length);
        for (int i = 0; i < checkers.length && !multiCallback.done(); ++i) {
            checkers[i].check(envelope, session, multiCallback);
        }
    }

    private static class Callback implements FutureCallback<SoResolution> {
        private final AtomicBoolean done = new AtomicBoolean();
        private final FutureCallback<SoResolution> callback;
        private SoResolution resolution = SoResolution.UNKNOWN;
        private int left;

        Callback(
            final FutureCallback<SoResolution> callback,
            final int left)
        {
            this.callback = callback;
            this.left = left;
        }

        public boolean done() {
            return done.get();
        }

        @Override
        public void cancelled() {
            if (done.compareAndSet(false, true)) {
                callback.completed(SoResolution.CANCELLED);
            }
        }

        @Override
        public void completed(final SoResolution resolution) {
            SoResolution currentResolution;
            synchronized (this) {
                if (resolution.compareTo(this.resolution) < 0) {
                    this.resolution = resolution;
                }
                --left;
                if ((left == 0 || resolution == SoResolution.ACCEPT)
                    && done.compareAndSet(false, true))
                {
                    currentResolution = this.resolution;
                } else {
                    return;
                }
            }
            callback.completed(currentResolution);
        }

        @Override
        public void failed(final Exception e) {
            if (done.compareAndSet(false, true)) {
                callback.completed(SoResolution.ERROR);
            }
        }
    }
}

