package ru.yandex.mail.so.spampkin;

import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.util.ip.CidrListConfig;

public interface SpampkinConfig extends HttpProxyConfig {
    ParameterConfig<String> HAM_CHECK_NAME = new ParameterConfig<>(
        "ham-check-name",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> SPAM_CHECK_NAME = new ParameterConfig<>(
        "spam-check-name",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> REJECT_CHECK_NAME = new ParameterConfig<>(
        "reject-check-name",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Boolean> OUT_MAIL = new ParameterConfig<>(
        "out-mail",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    HttpHostConfig jrbldConfig();

    String hamCheckName();

    String spamCheckName();

    String rejectCheckName();

    HttpHostConfig shinglerConfig();

    CidrListConfig intranetIps();

    boolean outMail();
}

