package ru.yandex.mail.so.spampkin;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class SpampkinConfigBuilder
    extends AbstractSpampkinConfigBuilder<SpampkinConfigBuilder>
{
    public SpampkinConfigBuilder() {
        super(SpampkinConfigDefaults.INSTANCE);
    }

    public SpampkinConfigBuilder(final SpampkinConfig config) {
        super(config);
    }

    public SpampkinConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, SpampkinConfigDefaults.INSTANCE);
    }

    public SpampkinConfigBuilder(
        final IniConfig config,
        final SpampkinConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SpampkinConfigBuilder self() {
        return this;
    }

    public ImmutableSpampkinConfig build() throws ConfigException {
        return new ImmutableSpampkinConfig(this);
    }
}

