package ru.yandex.mail.so.spampkin;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.logger.LoggersConfig;
import ru.yandex.logger.LoggersConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.util.ip.CidrListConfig;
import ru.yandex.util.ip.CidrListConfigDefaults;

public class SpampkinConfigDefaults
    extends HttpProxyConfigDefaults
    implements SpampkinConfig
{
    public static final String SO_RESOLUTION = "so_resolution";

    public static final SpampkinConfigDefaults INSTANCE =
        new SpampkinConfigDefaults();

    private static final LoggersConfig LOGGERS_CONFIG =
        new LoggersConfigBuilder(HttpProxyConfigDefaults.INSTANCE.loggers())
            .accessLoggers(
                new PatternMap<>(new SpampkinAccessLoggerConfigDefaults()));

    protected SpampkinConfigDefaults() {
    }

    @Override
    public HttpHostConfig jrbldConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String hamCheckName() {
        return null;
    }

    @Override
    public String spamCheckName() {
        return null;
    }

    @Override
    public String rejectCheckName() {
        return null;
    }

    @Override
    public HttpHostConfig shinglerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public CidrListConfig intranetIps() {
        return CidrListConfigDefaults.INSTANCE;
    }

    @Override
    public boolean outMail() {
        return false;
    }

    @Override
    public LoggersConfig loggers() {
        return LOGGERS_CONFIG;
    }

    private static class SpampkinAccessLoggerConfigDefaults
        extends ProxyAccessLoggerConfigDefaults
    {
        @Override
        public String logFormat() {
            return super.logFormat() + " %{" + SO_RESOLUTION + '}';
        }
    }
}

