package ru.yandex.mail.so.spampkin;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.mail.envelope.SmtpEnvelopeHolder;

public class StatingFastChecker implements SpampkinFastChecker {
    private final SpampkinFastChecker checker;
    private final TimeFrameQueue<SoResolution> resolutions;
    private final String checkerName;

    public StatingFastChecker(
        final SpampkinFastChecker checker,
        final TimeFrameQueue<SoResolution> resolutions)
    {
        this.checker = checker;
        this.resolutions = resolutions;
        checkerName = checker.getClass().getSimpleName();
    }

    @Override
    public void check(
        final SmtpEnvelopeHolder envelope,
        final ProxySession session,
        final FutureCallback<SoResolution> callback)
    {
        checker.check(
            envelope,
            session,
            new Callback(callback, session.logger()));
    }

    private class Callback implements FutureCallback<SoResolution> {
        private final FutureCallback<SoResolution> callback;
        private final Logger logger;

        Callback(
            final FutureCallback<SoResolution> callback,
            final Logger logger)
        {
            this.callback = callback;
            this.logger = logger;
        }

        @Override
        public void cancelled() {
            logger.warning("Check cancelled for " + checkerName);
            completed(SoResolution.CANCELLED);
        }

        @Override
        public void completed(final SoResolution resolution) {
            resolutions.accept(resolution);
            logger.info(
                "Check result for " + checkerName + " is " + resolution);
            callback.completed(resolution);
        }

        @Override
        public void failed(final Exception e) {
            logger.log(Level.WARNING, "Check failed for " + checkerName, e);
            completed(SoResolution.ERROR);
        }
    }
}

