CREATE SCHEMA IF NOT EXISTS tma;

CREATE TYPE tma.message_state AS ENUM (
    'accepted',
    'sent',
    'delivered',
    'seen',
    'error',
    'delivered_receipt_sent',
    'seen_receipt_sent',
    'error_receipt_sent'
);

CREATE TABLE tma.message (
    id                          BIGSERIAL           PRIMARY KEY,
    worker_id                   TEXT                NOT NULL,
    phone_number                TEXT                NOT NULL,
    message_template_id         TEXT                NOT NULL,
    message_template_locale     TEXT                NOT NULL,
    message_template_parameters TEXT[]              NOT NULL,
    state                       tma.message_state   NOT NULL,
    accepted_timestamp          TIMESTAMP           NOT NULL DEFAULT (CURRENT_TIMESTAMP),
    delivered_timestamp         TIMESTAMP           -- may be null for accepted and sent states
);

CREATE INDEX idx_worker_id_and_state ON tma.message (worker_id, state);

