package ru.yandex.tma;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

import javax.net.ServerSocketFactory;

public class PortSavingServerSocketFactory extends ServerSocketFactory {
    private final ServerSocketFactory serverSocketFactory;
    private volatile int lastPort = 0;

    public PortSavingServerSocketFactory(
        final ServerSocketFactory serverSocketFactory)
    {
        this.serverSocketFactory = serverSocketFactory;
    }

    public int lastPort() {
        return lastPort;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        lastPort = 0;
        return serverSocketFactory.createServerSocket();
    }

    @Override
    public ServerSocket createServerSocket(final int port) throws IOException {
        ServerSocket serverSocket =
            serverSocketFactory.createServerSocket(port);
        lastPort = serverSocket.getLocalPort();
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(final int port, final int backlog)
        throws IOException
    {
        ServerSocket serverSocket =
            serverSocketFactory.createServerSocket(port, backlog);
        lastPort = serverSocket.getLocalPort();
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(
        final int port,
        final int backlog,
        final InetAddress address)
        throws IOException
    {
        ServerSocket serverSocket =
            serverSocketFactory.createServerSocket(port, backlog, address);
        lastPort = serverSocket.getLocalPort();
        return serverSocket;
    }
}

