package ru.yandex.tma;

import java.io.IOException;
import java.net.ServerSocket;

import javax.net.ServerSocketFactory;

import org.jsmpp.session.connection.ServerConnection;
import org.jsmpp.session.connection.ServerConnectionFactory;
import org.jsmpp.session.connection.socket.ServerSocketConnection;

public class SimpleServerConnectionFactory implements ServerConnectionFactory {
    private final ServerSocketFactory serverSocketFactory;

    public SimpleServerConnectionFactory(
        final ServerSocketFactory serverSocketFactory)
    {
        this.serverSocketFactory = serverSocketFactory;
    }

    @Override
    public ServerConnection listen(final int port) throws IOException {
        ServerSocket socket = serverSocketFactory.createServerSocket(port);
        return new ServerSocketConnection(socket);
    }

    @Override
    public ServerConnection listen(final int port, final int timeout)
        throws IOException
    {
        ServerSocket socket = serverSocketFactory.createServerSocket(port);
        socket.setSoTimeout(timeout);
        return new ServerSocketConnection(socket);
    }

    @Override
    public ServerConnection listen(
        final int port,
        final int timeout,
        final int backlog)
        throws IOException
    {
        ServerSocket socket =
            serverSocketFactory.createServerSocket(port, backlog);
        socket.setSoTimeout(timeout);
        return new ServerSocketConnection(socket);
    }
}

