package ru.yandex.tma.config;

import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractTemplateConfigBuilder
    <T extends AbstractTemplateConfigBuilder<T>>
    implements ConfigBuilder<T>, TemplateConfig
{
    private String name;
    private Pattern pattern;
    private String locale;

    protected AbstractTemplateConfigBuilder(final TemplateConfig config) {
        name(config.name());
        pattern(config.pattern());
        locale(config.locale());
    }

    protected AbstractTemplateConfigBuilder(
        final IniConfig config,
        final TemplateConfig defaults)
        throws ConfigException
    {
        name = NAME.extract(config, defaults.name());
        pattern = PATTERN.extract(config, defaults.pattern());
        locale = LOCALE.extract(config, defaults.locale());
    }

    @Override
    public String name() {
        return name;
    }

    public T name(final String name) {
        this.name = name;
        return self();
    }

    @Override
    public Pattern pattern() {
        return pattern;
    }

    public T pattern(final Pattern pattern) {
        this.pattern = pattern;
        return self();
    }

    @Override
    public String locale() {
        return locale;
    }

    public T locale(final String locale) {
        this.locale = locale;
        return self();
    }
}

