package ru.yandex.tma.config;

import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableTemplateConfig
    implements ImmutableConfig, TemplateConfig
{
    private final String name;
    private final Pattern pattern;
    private final String locale;

    public ImmutableTemplateConfig(final TemplateConfig config)
        throws ConfigException
    {
        name = NAME.validate(config.name());
        pattern = PATTERN.validate(config.pattern());
        locale = LOCALE.validate(config.locale());
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public Pattern pattern() {
        return pattern;
    }

    @Override
    public String locale() {
        return locale;
    }
}

