package ru.yandex.tma.config;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableTmaConfig
    extends ImmutableHttpProxyConfig
    implements TmaConfig
{
    private final int smppPort;
    private final String messengerService;
    private final String messengerAccount;
    private final long deliveryTtl;
    private final long dbScanInterval;
    private final String systemId;
    private final String password;
    private final byte[] aesKey;
    private final byte[] aesIv;
    private final Map<String, ImmutableTemplateConfig> templates;
    private final ImmutablePgClientConfig pgClientConfig;
    private final ImmutableHttpHostConfig messengerGatewayConfig;
    private final ImmutableLoggerConfig smppAccessLoggerConfig;
    private final ImmutableLoggerConfig tskvLoggerConfig;

    public ImmutableTmaConfig(final TmaConfig config) throws ConfigException {
        super(config);
        smppPort = SMPP_PORT.validate(config.smppPort());
        messengerService =
            MESSENGER_SERVICE.validate(config.messengerService());
        messengerAccount =
            MESSENGER_ACCOUNT.validate(config.messengerAccount());
        deliveryTtl = DELIVERY_TTL.validate(config.deliveryTtl());
        dbScanInterval = DB_SCAN_INTERVAL.validate(config.dbScanInterval());
        systemId = SYSTEM_ID.validate(config.systemId());
        password = PASSWORD.validate(config.password());
        aesKey = AES_KEY.validate(config.aesKey());
        aesIv = AES_KEY.validate(config.aesIv());
        Map<String, ? extends TemplateConfig> templates = config.templates();
        this.templates = new LinkedHashMap<>(templates.size() << 1);
        for (Map.Entry<String, ? extends TemplateConfig> entry
            : templates.entrySet())
        {
            String name = entry.getKey();
            this.templates.put(
                name,
                TmaConfig.templateParser(name).validate(entry.getValue()));
        }
        pgClientConfig = PG_CLIENT_CONFIG.validate(config.pgClientConfig());
        messengerGatewayConfig =
            MESSENGER_GATEWAY_CONFIG.validate(config.messengerGatewayConfig());
        smppAccessLoggerConfig =
            SMPP_ACCESS_LOGGER_CONFIG.validate(
                config.smppAccessLoggerConfig());
        tskvLoggerConfig =
            TSKV_LOGGER_CONFIG.validate(config.tskvLoggerConfig());
    }

    @Override
    public int smppPort() {
        return smppPort;
    }

    @Override
    public String messengerService() {
        return messengerService;
    }

    @Override
    public String messengerAccount() {
        return messengerAccount;
    }

    @Override
    public long deliveryTtl() {
        return deliveryTtl;
    }

    @Override
    public long dbScanInterval() {
        return dbScanInterval;
    }

    @Override
    public String systemId() {
        return systemId;
    }

    @Override
    public String password() {
        return password;
    }

    @Override
    public byte[] aesKey() {
        return aesKey;
    }

    @Override
    public byte[] aesIv() {
        return aesIv;
    }

    @Override
    public Map<String, ImmutableTemplateConfig> templates() {
        return templates;
    }

    @Override
    public ImmutablePgClientConfig pgClientConfig() {
        return pgClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig messengerGatewayConfig() {
        return messengerGatewayConfig;
    }

    @Override
    public ImmutableLoggerConfig smppAccessLoggerConfig() {
        return smppAccessLoggerConfig;
    }

    @Override
    public ImmutableLoggerConfig tskvLoggerConfig() {
        return tskvLoggerConfig;
    }
}

