package ru.yandex.tma.config;

import java.util.regex.Pattern;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.NonEmptyValidator;

public interface TemplateConfig {
    ParameterConfig<String> NAME =
        new ParameterConfig<String>(
            "name",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<Pattern> PATTERN =
        new ParameterConfig<>(
            "pattern",
            Pattern::compile,
            GenericFunction.identity());

    ParameterConfig<String> LOCALE =
        new ParameterConfig<String>(
            "locale",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    String name();

    Pattern pattern();

    String locale();
}

