package ru.yandex.tma.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class TemplateConfigBuilder
    extends AbstractTemplateConfigBuilder<TemplateConfigBuilder>
{
    public TemplateConfigBuilder() {
        super(TemplateConfigDefaults.INSTANCE);
    }

    public TemplateConfigBuilder(final TemplateConfig config) {
        super(config);
    }

    public TemplateConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, TemplateConfigDefaults.INSTANCE);
    }

    public TemplateConfigBuilder(
        final IniConfig config,
        final TemplateConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public TemplateConfigBuilder self() {
        return this;
    }

    public ImmutableTemplateConfig build() throws ConfigException {
        return new ImmutableTemplateConfig(this);
    }
}

