package ru.yandex.tma.config;

import java.util.Map;

import ru.yandex.base64.Base64Parser;
import ru.yandex.client.pg.config.ImmutablePgClientConfig;
import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigBuilder;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface TmaConfig extends HttpProxyConfig {
    ParameterConfig<Integer> SMPP_PORT =
        new ParameterConfig<>(
            "tma.smpp-port",
            Integer::valueOf,
            NonNegativeValidator.instance());

    ParameterConfig<String> MESSENGER_SERVICE =
        new ParameterConfig<>(
            "tma.messenger-service",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> MESSENGER_ACCOUNT =
        new ParameterConfig<>(
            "tma.messenger-account",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<Long> DELIVERY_TTL =
        new ParameterConfig<>(
            "tma.delivery-ttl",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());

    ParameterConfig<Long> DB_SCAN_INTERVAL =
        new ParameterConfig<>(
            "tma.db-scan-interval",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());

    ParameterConfig<String> SYSTEM_ID =
        new ParameterConfig<>(
            "tma.auth.system-id",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> PASSWORD =
        new ParameterConfig<>(
            "tma.auth.password",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<byte[]> AES_KEY =
        new ParameterConfig<>(
            "tma.aes.key",
            Base64Parser.INSTANCE,
            x -> x.clone());

    ParameterConfig<byte[]> AES_IV =
        new ParameterConfig<>(
            "tma.aes.iv",
            Base64Parser.INSTANCE,
            x -> x.clone());

    SectionConfig<
        PgClientConfig,
        ImmutablePgClientConfig,
        PgClientConfigBuilder>
        PG_CLIENT_CONFIG = new SectionConfig<>(
            "pg-client",
            PgClientConfigBuilder::new,
            ImmutablePgClientConfig::new);

    SectionConfig<
        HttpHostConfig,
        ImmutableHttpHostConfig,
        HttpHostConfigBuilder>
        MESSENGER_GATEWAY_CONFIG = new SectionConfig<>(
            "messenger-gateway",
            HttpHostConfigBuilder::new,
            ImmutableHttpHostConfig::new);

    SectionConfig<
        LoggerConfig,
        ImmutableLoggerConfig,
        LoggerConfigBuilder>
        SMPP_ACCESS_LOGGER_CONFIG = new SectionConfig<>(
            "smppaccesslog",
            LoggerConfigBuilder::new,
            ImmutableLoggerConfig::new);

    SectionConfig<
        LoggerConfig,
        ImmutableLoggerConfig,
        LoggerConfigBuilder>
        TSKV_LOGGER_CONFIG = new SectionConfig<>(
            "tskvlog",
            LoggerConfigBuilder::new,
            ImmutableLoggerConfig::new);

    static SectionConfig<
        TemplateConfig,
        ImmutableTemplateConfig,
        TemplateConfigBuilder>
    templateParser(final String name) {
        return new SectionConfig<>(
            name,
            TemplateConfigBuilder::new,
            ImmutableTemplateConfig::new);
    }

    int smppPort();

    String messengerService();

    String messengerAccount();

    long deliveryTtl();

    long dbScanInterval();

    String systemId();

    String password();

    byte[] aesKey();

    byte[] aesIv();

    Map<String, ? extends TemplateConfig> templates();

    PgClientConfig pgClientConfig();

    HttpHostConfig messengerGatewayConfig();

    LoggerConfig smppAccessLoggerConfig();

    LoggerConfig tskvLoggerConfig();
}

