package ru.yandex.tma.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class TmaConfigBuilder
    extends AbstractTmaConfigBuilder<TmaConfigBuilder>
{
    public TmaConfigBuilder() {
        super(TmaConfigDefaults.INSTANCE);
    }

    public TmaConfigBuilder(final TmaConfig config) {
        super(config);
    }

    public TmaConfigBuilder(final IniConfig config) throws ConfigException {
        super(config, TmaConfigDefaults.INSTANCE);
    }

    public TmaConfigBuilder(final IniConfig config, final TmaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public TmaConfigBuilder self() {
        return this;
    }

    public ImmutableTmaConfig build() throws ConfigException {
        return new ImmutableTmaConfig(this);
    }
}

