package ru.yandex.tma.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.client.pg.config.PgClientConfig;
import ru.yandex.client.pg.config.PgClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.PureLoggerConfigDefaults;

public class TmaConfigDefaults
    extends HttpProxyConfigDefaults
    implements TmaConfig
{
    public static final TmaConfigDefaults INSTANCE = new TmaConfigDefaults();

    protected TmaConfigDefaults() {
    }

    @Override
    public String name() {
        return "TMA";
    }

    @Override
    public int smppPort() {
        return -1;
    }

    @Override
    public String messengerService() {
        return null;
    }

    @Override
    public String messengerAccount() {
        return null;
    }

    @Override
    public long deliveryTtl() {
        return -1L;
    }

    @Override
    public long dbScanInterval() {
        return -1L;
    }

    @Override
    public String systemId() {
        return null;
    }

    @Override
    public String password() {
        return null;
    }

    @Override
    public byte[] aesKey() {
        return null;
    }

    @Override
    public byte[] aesIv() {
        return null;
    }

    @Override
    public Map<String, TemplateConfig> templates() {
        return Collections.emptyMap();
    }

    @Override
    public PgClientConfig pgClientConfig() {
        return PgClientConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig messengerGatewayConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig smppAccessLoggerConfig() {
        return ProxyAccessLoggerConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig tskvLoggerConfig() {
        return PureLoggerConfigDefaults.INSTANCE;
    }
}

