SELECT
    *
FROM
    tma.message
WHERE
    ((hostname = $1 AND state = 'accepted')
    OR
    (worker_id = $2
        AND
            (state = 'delivered'
            OR state = 'seen'
            OR state = 'error'
            OR state = 'failed')))
    AND accepted_timestamp >= (CURRENT_TIMESTAMP - $3 * INTERVAL '1 millisecond')
ORDER BY
    accepted_timestamp
LIMIT 1
