CREATE SCHEMA IF NOT EXISTS familypay;

CREATE TABLE familypay.family
(
    family_id                   TEXT    PRIMARY KEY,
    admin_uid                   BIGINT  NOT NULL UNIQUE,
    card_id                     TEXT    NOT NULL,
    card_mask                   TEXT    NOT NULL,
    card_currency               TEXT    NOT NULL,
    card_pay_system             TEXT    NOT NULL,
    -- becomes false on card unbinding
    card_bound                  BOOLEAN NOT NULL,
    origin                      TEXT    NOT NULL,
    default_day_limit           BIGINT  NOT NULL CHECK (default_day_limit >= 0),
    default_week_limit          BIGINT  NOT NULL CHECK (default_week_limit >= 0),
    default_month_limit         BIGINT  NOT NULL CHECK (default_month_limit >= 0),
    default_total_limit         BIGINT  NOT NULL CHECK (default_total_limit >= 0),
    default_blocked_services    TEXT[]  NOT NULL
);

CREATE INDEX idx_family_origin ON familypay.family (origin);

CREATE TABLE familypay.family_member
(
    uid                 BIGINT  PRIMARY KEY,
    family_id           TEXT    NOT NULL,
    enabled             BOOLEAN NOT NULL,
    day_limit           BIGINT  NOT NULL CHECK (day_limit >= 0),
    week_limit          BIGINT  NOT NULL CHECK (week_limit >= 0),
    month_limit         BIGINT  NOT NULL CHECK (month_limit >= 0),
    total_limit         BIGINT  NOT NULL CHECK (total_limit >= 0),
    blocked_services    TEXT[]  NOT NULL,

    FOREIGN KEY (family_id) REFERENCES familypay.family (family_id)
        ON DELETE CASCADE
        DEFERRABLE INITIALLY DEFERRED
);

CREATE INDEX idx_user_family ON familypay.family_member (family_id);

CREATE TYPE familypay.payment_status AS ENUM (
    'started',
    'completed',
    'rejected'
);

CREATE TABLE familypay.payment
(
    id              TEXT                        PRIMARY KEY,
    status          familypay.payment_status    NOT NULL,
    initiator_uid   BIGINT                      NOT NULL,
    card_id         TEXT                        NOT NULL,
    timestamp       TIMESTAMP                   NOT NULL DEFAULT (CURRENT_TIMESTAMP),
    amount          BIGINT                      NOT NULL CHECK (amount > 0),

    FOREIGN KEY (initiator_uid) REFERENCES familypay.family_member (uid) ON DELETE CASCADE
);

CREATE INDEX idx_user_payments ON familypay.payment (initiator_uid);

CREATE TABLE familypay.expenses
(
    uid     BIGINT PRIMARY KEY,
    total   BIGINT NOT NULL,

    FOREIGN KEY (uid) REFERENCES familypay.family_member (uid) ON DELETE CASCADE
);

