UPDATE
    familypay.family f
SET
    default_allowed_services = calculated_services
FROM (
    SELECT
        family_id, array_agg(s ORDER BY s) calculated_services
    FROM (
        SELECT
            family_id,
            unnest(
                array[
                    'travel',
                    'lavka',
                    'drive',
                    'eats',
                    'kinopoisk',
                    'market',
                    'taxi',
                    'passport',
                    'games',
                    'dostavka'])
        FROM
            familypay.family
        WHERE
            default_blocked_services != '{}'
        EXCEPT
        SELECT
            family_id, unnest(default_blocked_services)
        FROM familypay.family
    ) t(family_id, s)
    GROUP BY
        family_id
) ids
WHERE
    f.family_id = ids.family_id;

ALTER TABLE familypay.family DROP COLUMN default_blocked_services;


UPDATE
    familypay.family_member m
SET
    allowed_services = calculated_services
FROM (
    SELECT
        uid, array_agg(s ORDER BY s) calculated_services
    FROM (
        SELECT
            uid,
            unnest(
                array[
                    'travel',
                    'lavka',
                    'drive',
                    'eats',
                    'kinopoisk',
                    'market',
                    'taxi',
                    'passport',
                    'games',
                    'dostavka'])
        FROM
            familypay.family_member
        WHERE
            blocked_services != '{}'
        EXCEPT
        SELECT
            uid, unnest(blocked_services)
        FROM familypay.family_member
    ) t(uid, s)
    GROUP BY
        uid
) ids
WHERE
    m.uid = ids.uid;

ALTER TABLE familypay.family_member DROP COLUMN blocked_services;

