package ru.yandex.passport.familypay.backend;

import ru.yandex.json.dom.JsonObject;

public abstract class AbstractFilterFamilypayCallback<T, R>
    implements FamilypayCallback<T>
{
    protected final FamilypayCallback<? super R> callback;

    protected AbstractFilterFamilypayCallback(
        final FamilypayCallback<? super R> callback)
    {
        this.callback = callback;
    }

    @Override
    public RequestContext context() {
        return callback.context();
    }

    @Override
    public void cancelled() {
        callback.cancelled();
    }

    @Override
    public void failed(final Exception e) {
        callback.failed(e);
    }

    @Override
    public void failed(
        final ErrorType errorType,
        final String message,
        final Throwable cause)
    {
        callback.failed(errorType, message, cause);
    }

    @Override
    public void sendResponse(final JsonObject result) {
        callback.sendResponse(result);
    }

    @Override
    public void emptyResponse() {
        callback.emptyResponse();
    }

    @Override
    public void emptyResponse(final String logMessage) {
        callback.emptyResponse(logMessage);
    }
}

