package ru.yandex.passport.familypay.backend;

public class AddFamilyMemberEvent extends FamilyMemberChangeEvent {
    public AddFamilyMemberEvent(final String familyId, final long uid) {
        super(familyId, uid);
    }

    @Override
    protected void blackboxFamilyNotFound(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId)
    {
        callback.context().session().logger().info(
            "Family " + familyId + " not found in blackbox, skipping add");
        // We still need to notify about family disband
        callback.completed(Boolean.FALSE);
    }

    @Override
    protected void blackboxFamilyFoundWithoutMember(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId,
        final long adminUid)
    {
        callback.context().session().logger().info(
            "Uid " + uid + " not in family " + familyId + ", skipping add");
        callback.completed(Boolean.FALSE);
    }

    @Override
    protected void blackboxFamilyFoundWithMember(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId,
        final long adminUid)
    {
        if (adminUid == uid) {
            callback.context().session().logger().info(
                "Skipping admin self-notification about family start");
        } else {
            callback.context().server().pusher().notifyOnMemberAdd(
                callback.context(),
                adminUid,
                uid,
                eventId);
        }
        callback.completed(Boolean.FALSE);
    }
}

