package ru.yandex.passport.familypay.backend;

import ru.yandex.function.GenericUnaryOperator;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.util.string.StringUtils;

public enum CardIdParser implements GenericUnaryOperator<String, Exception> {
    INSTANCE;

    @Override
    public String apply(String value) throws Exception {
        value = NonEmptyValidator.TRIMMED.apply(value);
        value = StringUtils.removePrefix(value, 'x');
        value = StringUtils.removePrefix(value, "card-x");
        return StringUtils.concat('x', value);
    }
}

