package ru.yandex.passport.familypay.backend;

public class DeleteFamilyMemberEvent extends FamilyMemberChangeEvent {
    public DeleteFamilyMemberEvent(final String familyId, final long uid) {
        super(familyId, uid);
    }

    @Override
    protected void blackboxFamilyNotFound(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId)
    {
        // Whole family was deleted
        callback.context().server().pusher().notifyMemberOnFamilyDelete(
            callback.context(),
            uid,
            eventId);
        callback.completed(Boolean.FALSE);
    }

    @Override
    protected void blackboxFamilyFoundWithoutMember(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId,
        final long adminUid)
    {
        callback.context().server().pusher().notifyOnMemberDelete(
            callback.context(),
            adminUid,
            uid,
            eventId);
        callback.completed(Boolean.FALSE);
    }

    @Override
    protected void blackboxFamilyFoundWithMember(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId,
        final long adminUid)
    {
        callback.context().session().logger().info(
            "Uid " + uid + " present in family "
            + familyId + ", skipping delete");
        callback.completed(Boolean.FALSE);
    }
}

