package ru.yandex.passport.familypay.backend;

import ru.yandex.http.util.YandexHttpStatus;

public enum ErrorType {
    INTERNAL_ERROR(
        1,
        YandexHttpStatus.SC_SERVICE_UNAVAILABLE,
        "Service unavailable"),
    FAMILY_ALREADY_EXISTS(
        2,
        YandexHttpStatus.SC_CONFLICT,
        "Family already exists"),
    CLIENT_CLOSED_CONNECTION(
        3,
        YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST,
        "Client closed connection"),
    FAMILY_NOT_FOUND(
        4,
        YandexHttpStatus.SC_NOT_FOUND,
        "Family not found"),
    BLACKBOX_FAILED(
        5,
        YandexHttpStatus.SC_BAD_GATEWAY,
        "Blackbox request failed"),
    ADMIN_MISMATCH(
        6,
        YandexHttpStatus.SC_FORBIDDEN,
        "Family admin uid mismatch"),
    FAMILY_MISMATCH(
        7,
        YandexHttpStatus.SC_CONFLICT,
        "Family settings mismatch"),
    MALFORMED_REQUEST(
        8,
        YandexHttpStatus.SC_BAD_REQUEST,
        "Malformed request"),
    MALFORMED_URI(
        9,
        YandexHttpStatus.SC_BAD_REQUEST,
        "Malformed URI"),
    CONSTRAINT_VIOLATION(
        10,
        YandexHttpStatus.SC_SERVICE_UNAVAILABLE,
        "Constraint violation"),
    PAYMENT_NOT_FOUND(
        11,
        YandexHttpStatus.SC_NOT_FOUND,
        "Payment not found"),
    USER_NOT_FOUND(
        12,
        YandexHttpStatus.SC_NOT_FOUND,
        "User not found"),
    PAYMENT_NOT_ACCEPTABLE(
        13,
        YandexHttpStatus.SC_CONFLICT,
        "Payment not acceptable"),
    FAMILY_PAYMENTS_DISABLED(
        14,
        YandexHttpStatus.SC_CONFLICT,
        "Family payments disabled"),
    SERVICE_ID_NOT_FOUND(
        15,
        YandexHttpStatus.SC_NOT_FOUND,
        "Service id not found"),
    CARD_NOT_FOUND(
        16,
        YandexHttpStatus.SC_NOT_FOUND,
        "Card not found"),
    CONCURRENT_PHONE_STATUS_CHANGE(
        17,
        YandexHttpStatus.SC_CONFLICT,
        "Concurrent user phone status modification");

    private final int errorCode;
    private final int httpCode;
    private final String description;

    ErrorType(
        final int errorCode,
        final int httpCode,
        final String description)
    {
        this.errorCode = errorCode;
        this.httpCode = httpCode;
        this.description = description;
    }

    public int errorCode() {
        return errorCode;
    }

    public int httpCode() {
        return httpCode;
    }

    public String description() {
        return description;
    }
}

