package ru.yandex.passport.familypay.backend;

import java.util.Map;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.function.StringBuilderable;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;

public class Family extends AbstractStringBuilderable {
    private final FamilyInfo familyInfo;
    private final Map<Long, FamilyMember> familyMembers;

    public Family(
        final FamilyInfo familyInfo,
        final Map<Long, FamilyMember> familyMembers)
    {
        this.familyInfo = familyInfo;
        this.familyMembers = familyMembers;
    }

    public FamilyInfo familyInfo() {
        return familyInfo;
    }

    public Map<Long, FamilyMember> familyMembers() {
        return familyMembers;
    }

    public static boolean familypayEnabled(final Family family) {
        return family != null
            && family.familyInfo.cardInfo().bound()
            && family.familyMembers.get(family.familyInfo.adminUid())
                .hasSecurePhone();
    }

    public JsonMap toJson(
        final ContainerFactory containerFactory,
        final boolean singleLimit)
    {
        JsonMap result = familyInfo.toJson(containerFactory, singleLimit);
        int size = familyMembers.size();
        JsonList userRestrictions = new JsonList(containerFactory, size);
        result.put("userRestrictions", userRestrictions);
        for (FamilyMember familyMember: familyMembers.values()) {
            userRestrictions.add(
                familyMember.toJson(containerFactory, singleLimit));
        }
        return result;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append("Family(");
        familyInfo.toStringBuilder(sb);
        sb.append(',');
        StringBuilderable.toStringBuilder(sb, familyMembers.values());
        sb.append(')');
    }
}

