package ru.yandex.passport.familypay.backend;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import org.apache.http.HttpException;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.json.dom.JsonObject;

public class FamilyBindCardHandler extends FamilyHandlerBase {
    public static final SqlQuery BIND_CARD =
        new SqlQuery("bind-card.sql", FamilyBindCardHandler.class);

    public FamilyBindCardHandler(final FamilypayBackend server) {
        super(server, false);
    }

    @Override
    protected void handle(
        final String familyId,
        final JsonObject payload,
        final RequestContext context)
        throws HttpException
    {
        String cardId =
            context.session().params().get("cardId", CardIdParser.INSTANCE);
        Tuple tuple = Tuple.tuple();
        tuple.addString(familyId);
        tuple.addString(cardId);
        FamilyCallback callback = new FamilyCallback(context, tuple);
        FamilyHandler.findFamily(familyId, callback);
    }

    private static class FamilyCallback
        extends AbstractFamilypayCallback<Family>
    {
        private final Tuple tuple;

        FamilyCallback(
            final RequestContext context,
            final Tuple tuple)
        {
            super(context);
            this.tuple = tuple;
        }

        @Override
        public void completed(final Family family) {
            context.server().pgClient().executeOnMaster(
                BIND_CARD,
                tuple,
                context.session().listener(),
                new Callback(context, family));
        }
    }

    private static class Callback
        extends AbstractFamilypayCallback<RowSet<Row>>
    {
        private final Family oldFamily;

        Callback(final RequestContext context, final Family oldFamily) {
            super(context);
            this.oldFamily = oldFamily;
        }

        @Override
        public void completed(final RowSet<Row> rowSet) {
            if (rowSet.rowCount() <= 0) {
                failed(ErrorType.CARD_NOT_FOUND, null, null);
            } else {
                emptyResponse();

                FamilyHandler.findFamily(
                    oldFamily.familyInfo().familyId(),
                    new FamilyChangeNotifyCallback(context, oldFamily));
            }
        }
    }
}

