package ru.yandex.passport.familypay.backend;

public abstract class FamilyChangeEventBase implements FamilyChangeEvent {
    protected final String familyId;
    protected final long uid;

    protected FamilyChangeEventBase(final String familyId, final long uid) {
        this.familyId = familyId;
        this.uid = uid;
    }

    @Override
    public String familyId() {
        return familyId;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + '(' + familyId + ',' + uid + ')';
    }

    @Override
    public void process(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId)
    {
        FamilyHandler.findFamily(
            familyId,
            new FamilyInfoCallback(callback, eventId));
    }

    protected abstract void familyNotFound(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId);

    protected abstract void familyFound(
        final FamilypayCallback<? super Boolean> callback,
        final String eventId,
        final Family family);

    private class FamilyInfoCallback
        extends AbstractFilterFamilypayCallback<Family, Boolean>
    {
        private final String eventId;

        FamilyInfoCallback(
            final FamilypayCallback<? super Boolean> callback,
            final String eventId)
        {
            super(callback);
            this.eventId = eventId;
        }

        @Override
        public void failed(
            final ErrorType errorType,
            final String message,
            final Throwable cause)
        {
            if (errorType == ErrorType.FAMILY_NOT_FOUND) {
                familyNotFound(callback, eventId);
            } else {
                failed(
                    new Exception(
                        "Error " + errorType + " occured: " + message,
                        cause));
            }
        }

        @Override
        public void completed(final Family family) {
            familyFound(callback, eventId, family);
        }
    }
}

