package ru.yandex.passport.familypay.backend;

public class FamilyChangeNotifyCallback
    extends AbstractFamilypayCallback<Family>
{
    private final Family oldFamily;
    private final String pushId;

    public FamilyChangeNotifyCallback(
        final RequestContext context,
        final Family oldFamily)
    {
        this(context, oldFamily, null);
    }

    public FamilyChangeNotifyCallback(
        final RequestContext context,
        final Family oldFamily,
        final String pushId)
    {
        super(context);
        this.oldFamily = oldFamily;
        this.pushId = pushId;
    }

    @Override
    public void completed(final Family family) {
        if (pushId == null) {
            // Autogenerate push id
            context.server().pusher().notifyOnFamilyChange(
                context,
                oldFamily,
                family);
        } else {
            context.server().pusher().notifyOnFamilyChange(
                context,
                oldFamily,
                family,
                pushId);
        }
    }
}

