package ru.yandex.passport.familypay.backend;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;

import ru.yandex.client.pg.SqlQuery;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.json.dom.JsonObject;

public class FamilyStopHandler extends FamilyHandlerBase {
    public static final SqlQuery DELETE_FAMILY =
        new SqlQuery("delete-family.sql", FamilyStopHandler.class);

    public FamilyStopHandler(final FamilypayBackend server) {
        super(server, false);
    }

    @Override
    protected void handle(
        final String familyId,
        final JsonObject payload,
        final RequestContext context)
    {
        FamilyCallback callback = new FamilyCallback(context, familyId);
        FamilyHandler.findFamily(familyId, callback);
    }

    private static class FamilyCallback
        extends AbstractFamilypayCallback<Family>
    {
        private final String familyId;

        FamilyCallback(
            final RequestContext context,
            final String familyId)
        {
            super(context);
            this.familyId = familyId;
        }

        @Override
        public void completed(final Family family) {
            Long adminUid =
                (Long) context.session().context().getAttribute(
                    HttpServer.TVM_USER_UID);

            Tuple tuple = Tuple.tuple();
            tuple.addString(familyId);
            tuple.addLong(adminUid);
            context.server().pgClient().executeOnMaster(
                DELETE_FAMILY,
                tuple,
                context.session().listener(),
                new Callback(context, family));
        }
    }

    private static class Callback
        extends AbstractFamilypayCallback<RowSet<Row>>
    {
        private final Family family;

        Callback(final RequestContext context, final Family family) {
            super(context);
            this.family = family;
        }

        @Override
        public void completed(final RowSet<Row> rowSet) {
            if (rowSet.rowCount() <= 0) {
                failed(ErrorType.FAMILY_NOT_FOUND, null, null);
            } else {
                emptyResponse();
                context.server().pusher().notifyOnFamilyChange(
                    context,
                    family,
                    null);
            }
        }
    }
}

